﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.Windows.Forms;

namespace RacetrackSimulator
{
    class Greyhound
    {
        // Fields
        public int distance;
        public int Location;
        public PictureBox MyPictureBox;
        public Random MyRandom;
        public int RacetrackLength;
        public int StartingPosition;

        // Methods
        public Greyhound()
        {
            this.MyPictureBox = null;
            this.Location = 0;
        }


        public bool Run()
        {
            Point location = this.MyPictureBox.Location;
            if ((location.X + this.MyPictureBox.Width) > this.RacetrackLength)
            {
                return true;
            }
            location.X += this.distance;
            this.MyPictureBox.Location = location;
            return false;
        }


        public void TakeStartingPosition()
        {
            this.MyPictureBox.Location = new Point(this.StartingPosition, this.Location);
        }


    }

}
